<?php
// categories.php

include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';


setupCORS();

requireAuth();

    if ($_SERVER['REQUEST_METHOD'] == 'GET') {
        requirePermission('article', 'view');

        if (isset($_GET['id_categorie'])) {
            $query = "SELECT * FROM categories WHERE id_categorie = :id_categorie";
            $params = array(':id_categorie' => $_GET['id_categorie']);
            $result = metodGet($query, $params);
            echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
        } else {
            $query = "SELECT * FROM categories ORDER BY nom_categorie";
            $result = metodGet($query);
            echo json_encode($result->fetchAll());
        }
        header("HTTP/1.1 200 OK");
        exit();
    }

if ($_POST['METHOD'] == 'POST') {
    unset($_POST['METHOD']);
    
    try {
        $query = "INSERT INTO categories(
                    categorie_code, reference, nom_categorie, description, user_cre
                  ) VALUES (
                    :categorie_code, :reference, :nom_categorie, :description, :user_cre
                  )";
        
        $queryAutoIncrement = "SELECT MAX(id_categorie) as id_categorie FROM categories";
        
        $params = array(
            ':categorie_code' => $_POST['categorie_code'],
            ':reference' => $_POST['reference'],
            ':nom_categorie' => $_POST['nom_categorie'],
            ':description' => $_POST['description'],
            ':user_cre' => $_POST['user_cre']
        );
        
        $result = metodPost($query, $queryAutoIncrement, $params, 'categories');
        echo json_encode($result);
        header("HTTP/1.1 200 OK");
        
    } catch (Exception $e) {
        header("HTTP/1.1 500 Internal Server Error");
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit();
}

if ($_POST['METHOD'] == 'PUT') {
    unset($_POST['METHOD']);
    $id_categorie = $_GET['id_categorie'];
    
    $query = "UPDATE categories SET 
                categorie_code = :categorie_code,
                reference = :reference,
                nom_categorie = :nom_categorie,
                description = :description,
                user_upd = :user_upd
              WHERE id_categorie = :id_categorie";
    
    $params = array(
        ':id_categorie' => $id_categorie,
        ':categorie_code' => $_POST['categorie_code'],
        ':reference' => $_POST['reference'],
        ':nom_categorie' => $_POST['nom_categorie'],
        ':description' => $_POST['description'],
        ':user_upd' => $_POST['user_upd']
    );
    
    $result = metodPut($query, $params, 'categories');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'DELETE') {
    unset($_POST['METHOD']);
    $id = $_GET['id_categorie'];
    $query = "DELETE FROM categories WHERE id_categorie = :id";
    $params = array(':id' => $id);
    $result = metodDelete($query, $params, 'categories');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

header("HTTP/1.1 400 Bad Request");
?>
