<?php
// user_profile.php

include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Protect all routes with authentication
requireAuth();

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (!isset($_GET['idUser'])) {
        http_response_code(400);
        echo json_encode(['error' => true, 'message' => 'User ID is required']);
        exit();
    }

    try {
        // Get current user info from token
        $decoded = Auth::validateToken();
        $currentUserId = $decoded->user->id;
        $currentUserRole = $decoded->user->role;
        $requestedUserId = $_GET['idUser'];

        // Check if user is requesting their own profile OR is admin
        if ($currentUserId != $requestedUserId && $currentUserRole !== 'admin') {
            http_response_code(403);
            echo json_encode(['error' => true, 'message' => 'Access denied. You can only view your own profile.']);
            exit();
        }

        $query = "SELECT idUser, username, role, profile, active FROM users WHERE idUser = :idUser";
        $params = array(':idUser' => $requestedUserId);
        $result = metodGet($query, $params);
        $user = $result->fetch(PDO::FETCH_ASSOC);
        
        if (!$user) {
            http_response_code(404);
            echo json_encode(['error' => true, 'message' => 'User not found']);
            exit();
        }

        header('Content-Type: application/json');
        echo json_encode($user);
        exit();
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => true, 'message' => 'Failed to fetch user data: ' . $e->getMessage()]);
        exit();
    }
}

// Handle password update
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['METHOD']) && $_POST['METHOD'] == 'PUT') {
    unset($_POST['METHOD']);
    
    try {
        $decoded = Auth::validateToken();
        $currentUserId = $decoded->user->id;
        $currentUserRole = $decoded->user->role;
        $requestedUserId = $_GET['idUser'];

        // Check if user is updating their own profile OR is admin
        if ($currentUserId != $requestedUserId && $currentUserRole !== 'admin') {
            http_response_code(403);
            echo json_encode(['error' => true, 'message' => 'Access denied. You can only update your own profile.']);
            exit();
        }

        // Handle password update
        if (isset($_POST['password'])) {
            $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
            $user_upd = $_POST['user_upd'] ?? $decoded->user->username;

            $query = "UPDATE users SET password=:password, user_upd=:user_upd WHERE idUser=:idUser";
            $params = array(
                ':idUser' => $requestedUserId,
                ':password' => $password,
                ':user_upd' => $user_upd
            );
            $result = metodPut($query, $params, 'users');
            echo json_encode($result);
            header("HTTP/1.1 200 OK");
            exit();
        }

        // Handle username update (only for own profile or admin)
        if (isset($_POST['username'])) {
            $username = $_POST['username'];
            $user_upd = $_POST['user_upd'] ?? $decoded->user->username;

            $query = "UPDATE users SET username=:username, user_upd=:user_upd WHERE idUser=:idUser";
            $params = array(
                ':idUser' => $requestedUserId,
                ':username' => $username,
                ':user_upd' => $user_upd
            );
            $result = metodPut($query, $params, 'users');
            echo json_encode($result);
            header("HTTP/1.1 200 OK");
            exit();
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => true, 'message' => 'Update failed: ' . $e->getMessage()]);
        exit();
    }
}

header("HTTP/1.1 400 Bad Request");
echo json_encode(['error' => true, 'message' => 'Invalid request method']);
?>