<?php
// refresh_token.php
include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // Validate current token
        $decoded = Auth::validateToken();
        
        // Get user data from decoded token
        $userData = [
            'idUser' => $decoded->user->id,
            'username' => $decoded->user->username,
            'role' => $decoded->user->role,
            'profile' => $decoded->user->profile
        ];
        
        // Generate new token with extended duration
        $token = Auth::generateToken($userData);
        
        echo json_encode([
            'token' => $token,
            'message' => 'Token refreshed successfully'
        ]);
        http_response_code(200);
        
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(401);
    }
    exit();
}