<?php
// fournisseur.php

include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}


requireAuth();

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_fournisseur'])) {
        $query = "SELECT * FROM fournisseur WHERE id_fournisseur = :id_fournisseur";
        $params = array(':id_fournisseur' => $_GET['id_fournisseur']);
        $result = metodGet($query, $params);
        echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
    } else {
        $query = "SELECT *FROM fournisseur";
        $result = metodGet($query);
        echo json_encode($result->fetchAll());
    }
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'POST') {

    unset($_POST['METHOD']);
    
    try {
        $categorie_code = $_POST['categorie_code'];
        $Code_Fournisseur = reference_generator($categorie_code);
        
        $query = "INSERT INTO fournisseur(
                    Code_Fournisseur, categorie_code, raison_sociale, adresse, 
                    telephone, email, site_web, numero_fiscal, user_cre
                  ) VALUES (
                    :Code_Fournisseur, :categorie_code, :raison_sociale, :adresse,
                    :telephone, :email, :site_web, :numero_fiscal, :user_cre
                  )";
        
        $queryAutoIncrement = "SELECT MAX(id_fournisseur) as id_fournisseur FROM fournisseur";
        
        $params = array(
            ':Code_Fournisseur' => $Code_Fournisseur,
            ':categorie_code' => $categorie_code,
            ':raison_sociale' => $_POST['raison_sociale'],
            ':adresse' => $_POST['adresse'],
            ':telephone' => $_POST['telephone'],
            ':email' => $_POST['email'],
            ':site_web' => $_POST['site_web'],
            ':numero_fiscal' => $_POST['numero_fiscal'],
            ':user_cre' => $_POST['user_cre']
        );
        
        $result = metodPost($query, $queryAutoIncrement, $params, 'fournisseur');
        echo json_encode($result);
        header("HTTP/1.1 200 OK");
        
    } catch (Exception $e) {
        header("HTTP/1.1 500 Internal Server Error");
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit();
}

if ($_POST['METHOD'] == 'PUT') {
    unset($_POST['METHOD']);
    $id_fournisseur = $_GET['id_fournisseur'];
    
    $query = "UPDATE fournisseur SET 
                categorie_code = :categorie_code,
                raison_sociale = :raison_sociale,
                adresse = :adresse,
                telephone = :telephone,
                email = :email,
                site_web = :site_web,
                numero_fiscal = :numero_fiscal,
                user_upd = :user_upd
              WHERE id_fournisseur = :id_fournisseur";
    
    $params = array(
        ':id_fournisseur' => $id_fournisseur,
        ':categorie_code' => $_POST['categorie_code'],
        ':raison_sociale' => $_POST['raison_sociale'],
        ':adresse' => $_POST['adresse'],
        ':telephone' => $_POST['telephone'],
        ':email' => $_POST['email'],
        ':site_web' => $_POST['site_web'],
        ':numero_fiscal' => $_POST['numero_fiscal'],
        ':user_upd' => $_POST['user_upd']
    );
    
    $result = metodPut($query, $params, 'fournisseur');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'DELETE') {
    unset($_POST['METHOD']);
    $id = $_GET['id_fournisseur'];
    $query = "DELETE FROM fournisseur WHERE id_fournisseur = :id";
    $params = array(':id' => $id);
    $result = metodDelete($query, $params, 'fournisseur');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

header("HTTP/1.1 400 Bad Request");
?>
