<?php

function getCurrentDetailInfo($id_detail_vente) {
    $query = "SELECT dv.*, v.montant_total as vente_total
              FROM details_ventes dv
              JOIN ventes v ON dv.id_vente = v.id_vente
              WHERE dv.id_detail_vente = :id_detail_vente";
              
    $result = metodGet($query, array(':id_detail_vente' => $id_detail_vente));
    $detail = $result->fetch(PDO::FETCH_ASSOC);
    
    if (!$detail) {
        throw new Exception("Sale detail not found");
    }
    
    return $detail;
}

function calculateNewTotal($id_vente, $postData, $currentDetail) {
    // Get all details for this sale
    $query = "SELECT id_detail_vente, quantite, prix_vente_unitaire 
              FROM details_ventes 
              WHERE id_vente = :id_vente";
    $result = metodGet($query, array(':id_vente' => $id_vente));
    $details = $result->fetchAll(PDO::FETCH_ASSOC);
    
    $newTotal = 0;
    foreach ($details as $detail) {
        if ($detail['id_detail_vente'] == $currentDetail['id_detail_vente']) {
            // Use new values for the updated detail
            $newTotal += floatval($postData['quantite']) * floatval($postData['prix_vente_unitaire']);
        } else {
            // Use existing values for other details
            $newTotal += floatval($detail['quantite']) * floatval($detail['prix_vente_unitaire']);
        }
    }
    
    return $newTotal;
}

function updateSaleDetail($id_detail_vente, $postData) {
    $montant_total = floatval($postData['quantite']) * floatval($postData['prix_vente_unitaire']);
    
    $query = "UPDATE details_ventes 
              SET quantite = :quantite,
                  prix_vente_unitaire = :prix_vente_unitaire,
                  montant_total = :montant_total,
                  user_upd = :user_upd,
                  date_upd = CURRENT_TIMESTAMP
              WHERE id_detail_vente = :id_detail_vente";
              
    $params = array(
        ':id_detail_vente' => $id_detail_vente,
        ':quantite' => $postData['quantite'],
        ':prix_vente_unitaire' => $postData['prix_vente_unitaire'],
        ':montant_total' => $montant_total,
        ':user_upd' => $postData['user_upd'] ?? 'SYSTEM'
    );
    
    return metodPut($query, $params, 'details_ventes');
}

function updatePaymentPlanStatus($id_paiement_tranche) {
    $query = "UPDATE paiements_clients_tranches 
              SET statut_tranches = 
                  CASE 
                      WHEN NOT EXISTS (
                          SELECT 1 FROM reglements_tranches_clients 
                          WHERE id_paiement_tranche = :id_paiement_tranche 
                          AND statut_reglements = 'En attente'
                      ) THEN 'Terminé'
                      ELSE 'En cours'
                  END,
              date_upd = CURRENT_TIMESTAMP,
              user_upd = 'SYSTEM'
              WHERE id_paiement_tranche = :id_paiement_tranche";
              
    return metodPut($query, 
        array(':id_paiement_tranche' => $id_paiement_tranche), 
        'paiements_clients_tranches'
    );
}

?>