<?php
//selection.php
require_once 'auth.php';
include 'bd/myData.php';
include 'cors.php';
setupCORS();

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {

        $decoded = Auth::validateToken();
        $userRole = $decoded->user->role;
        
        if (isset($_GET['user'])) {

            if ($userRole !== 'admin') {
                throw new Exception('Access denied: Admin privileges required');
            }
            
            $query = "SELECT * FROM users;";
            $result = metodGet($query);
            
            if ($result->rowCount() > 0) {
                echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
            } else {
                echo json_encode([]);
            }
        }

        if (isset($_GET['profile'])) {

            if (!in_array($userRole, ['admin', 'manager'])) {
                throw new Exception('Access denied: Insufficient privileges');
            }
            
            $query = "SELECT * FROM profiles;";
            $result = metodGet($query);
            
            if ($result->rowCount() > 0) {
                echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
            } else {
                echo json_encode([]);
            }
        }

        if (isset($_GET['idUser']) && isset($_GET['visibility'])) {
            if ($userRole !== 'admin' && $decoded->user->id !== $_GET['idUser']) {
                throw new Exception('Access denied: Can only view own visibility settings');
            }
            
            $query = "SELECT p.page, p.visibility FROM profile p JOIN users u ON p.profile = u.profile WHERE u.idUser = :idUser;";
            $params = array(':idUser' => $_GET['idUser']);
            $result = metodGet($query, $params);
            echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
        }

        if (isset($_GET['pages']) && isset($_GET['profileV2'])) {

            if (!in_array($userRole, ['admin', 'manager'])) {
                throw new Exception('Access denied: Insufficient privileges');
            }
            
            $query = "SELECT page FROM pages WHERE page NOT IN (SELECT page FROM profile WHERE profile = :profile);";
            $params = array(':profile' => $_GET['profileV2']);
            $result = metodGet($query, $params);
            if ($result->rowCount() > 0) {
                echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
            } else {
                echo json_encode([]);
            }
        }

        if (isset($_GET['description'])) {

            $query = "SELECT c.description,c.Code FROM bsgcod c where tier=:tier;";
            $params = array(':tier' => $_GET['description']);
            $result = metodGet($query, $params);

            if ($result->rowCount() > 0) {
                echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
            } else {
                echo json_encode([]);
            }
        }

        if (isset($_GET['categorie'])) {
            $query = "SELECT Code, description, tier FROM bsgcod;";
            $result = metodGet($query);
        
            if ($result->rowCount() > 0) {
                echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
            } else {
                echo json_encode([]);
            }
        }

    } catch (Exception $e) {
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode(['error' => $e->getMessage()]);
        exit();
    }
    
    header("HTTP/1.1 200 OK");
    exit();
}